import React from "react";
import { View, TouchableOpacity, Pressable, Text, Image } from "react-native";
import { DrawerContentScrollView, DrawerItem } from "@react-navigation/drawer";
import useAuth from "../../../hooks/useAuth";
import { drawerStyle } from "./DrawerContainerStyle";
import TimesIcon from "../../../assets/svgs/drawer/times.svg";
import UserIcon from "../../../assets/svgs/drawer/user.svg";
import LoginIcon from "../../../assets/svgs/drawer/login.svg";
import LogoutIcon from "../../../assets/svgs/drawer/logout.svg";
import TrackOrderIcon from "../../../assets/svgs/drawer/track_order.svg";
import SettingsIcon from "../../../assets/svgs/drawer/settings.svg";
import HomeIcon from "../../../assets/svgs/drawer/home.svg";
import WishlistIcon from "../../../assets/svgs/drawer/wishlist.svg";
import RefundIcon from "../../../assets/svgs/drawer/refund.svg";
import { useDispatch } from "react-redux";
import { queryResponse } from "../../../redux/slices/util/processResponse.js";
import usePreferences from "../../../hooks/usePreferences";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";
import resetReduxStore from "../../../helper/resetReduxStore";

import { BASE_API_URL_STG } from "@env";
import { useState } from "react";
import CustomToastModal from "../../../src/components/CustomToastModal/CustomToastModal";
import useCustomToast from "../../../hooks/useCustomToast";
import useLangTranslation from "../../../hooks/useLangTranslation";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const iconSize = dpr(14);

const DrawerContainer = (props) => {
    const { trans } = useLangTranslation();
    const { access_token, user } = useAuth();
    const { company: { company_logo } = {} } = usePreferences();
    const dispatch = useDispatch();
    const [wait, setWait] = useState(false);
    const showToast = useCustomToast();
    return (
        <>
            <View style={drawerStyle.container}>
                <DrawerContentScrollView
                    {...props}
                    showsVerticalScrollIndicator={false}
                >
                    <View style={drawerStyle.header}>
                        <View>
                            <ProgressiveImage
                                source={{ uri: company_logo }}
                                style={drawerStyle.compIcon}
                            />
                        </View>
                        <Pressable onPress={props.navigation.closeDrawer}>
                            <View style={drawerStyle.closeIconCont}>
                                <CustomSVG svgIcon={TimesIcon}
                                    width={dpr(12, "w")}
                                    height={dpr(12)}
                                    fill={"#FFFFFF"}
                                />
                            </View>
                        </Pressable>
                    </View>
                    <TouchableOpacity
                        style={drawerStyle.user}
                        onPress={() =>
                            props.navigation.navigate(
                                access_token ? "MY ACCOUNT" : "login"
                            )
                        }
                    >
                        <View style={drawerStyle.userIcoin}>
                            {access_token ? (
                                <>
                                    {(user?.image || user?.picture_url) && <Image
                                        source={{
                                            uri: user?.image || user?.picture_url,
                                        }}
                                        style={drawerStyle.userImage}
                                    />}
                                </>
                            ) : (
                                <CustomSVG svgIcon={UserIcon} width={dpr(18)} height={dpr(18)} />
                            )}
                        </View>
                        <View>
                            <Text style={drawerStyle.noAccount}>
                                {access_token ? user?.name : trans("No Account")}
                            </Text>
                            <Text style={drawerStyle.createAccount}>
                                {access_token ? (
                                    user?.email
                                ) : (
                                    <Text>{trans("Create or login now")}</Text>
                                )}
                            </Text>
                        </View>
                    </TouchableOpacity>
                    <DrawerItem
                        style={drawerStyle.drawerItem}
                        label={() => {
                            return (
                                <View style={drawerStyle.itemContainer}>
                                    <CustomSVG svgIcon={HomeIcon}
                                        width={iconSize}
                                        height={iconSize}
                                        fill={'#DFDFDF'}
                                    />
                                    <Text style={drawerStyle.itemText}>
                                        {trans("Home")}
                                    </Text>
                                </View>
                            );
                        }}
                        onPress={() => props.navigation.navigate("Home")}
                    />
                    <DrawerItem
                        style={drawerStyle.drawerItem}
                        label={() => {
                            return (
                                <View style={drawerStyle.itemContainer}>
                                    <CustomSVG svgIcon={TrackOrderIcon}
                                        width={iconSize}
                                        height={iconSize}
                                    />
                                    <Text style={drawerStyle.itemText}>
                                        {trans("Track Order")}
                                    </Text>
                                </View>
                            );
                        }}
                        onPress={() => props.navigation.navigate("track your order")}
                    />
                    {access_token && (
                        <>
                            <DrawerItem
                                style={drawerStyle.drawerItem}
                                label={() => {
                                    return (
                                        <View style={drawerStyle.itemContainer}>
                                            <CustomSVG svgIcon={WishlistIcon}
                                                width={iconSize}
                                                height={iconSize}
                                            />
                                            <Text style={drawerStyle.itemText}>
                                                {trans("My Wishlist")}
                                            </Text>
                                        </View>
                                    );
                                }}
                                onPress={() =>
                                    props.navigation.navigate("my wishlist")
                                }
                            />
                            <DrawerItem
                                style={drawerStyle.drawerItem}
                                label={() => {
                                    return (
                                        <View style={drawerStyle.itemContainer}>
                                            <CustomSVG svgIcon={RefundIcon}
                                                width={iconSize}
                                                height={iconSize}
                                            />
                                            <Text style={drawerStyle.itemText}>
                                                {trans("Refund")}
                                            </Text>
                                        </View>
                                    );
                                }}
                                onPress={() => props.navigation.navigate("my refund")}
                            />
                        </>
                    )}
                    <DrawerItem
                        style={drawerStyle.drawerItem}
                        label={() => {
                            return (
                                <View style={drawerStyle.itemContainer}>
                                    <CustomSVG svgIcon={SettingsIcon}
                                        width={iconSize}
                                        height={iconSize}
                                    />
                                    <Text style={drawerStyle.itemText}>
                                        {trans("Settings")}
                                    </Text>
                                </View>
                            );
                        }}
                        onPress={() => props.navigation.navigate("settings")}
                    />
                    <View style={drawerStyle.hrLine} />
                    {access_token ? (
                        <View>
                            <DrawerItem
                                style={drawerStyle.drawerItem}
                                label={() => {
                                    return (
                                        <View style={drawerStyle.itemContainer}>
                                            <CustomSVG svgIcon={LogoutIcon}
                                                width={iconSize}
                                                height={iconSize}
                                            />
                                            <Text style={drawerStyle.itemText}>
                                                {trans("Logout")}
                                            </Text>
                                        </View>
                                    );
                                }}
                                onPress={async () => {
                                    props.navigation.closeDrawer();
                                    setWait(true);
                                    const LOGOUT_URL = `${BASE_API_URL_STG}/user/logout`;
                                    const response = await queryResponse(
                                        LOGOUT_URL,
                                        "GET",
                                        access_token
                                    );
                                    if (
                                        response?.records?.response?.status ==
                                        "Ok"
                                    ) {
                                        setWait(false);
                                        resetReduxStore(dispatch);
                                        showToast({
                                            text1: trans("Logout Successful."),
                                            type: "common",
                                            position: "bottom",
                                            props: { variant: "success" },
                                        });
                                    }
                                }}
                            />
                            <CustomToastModal
                                content={trans("Please wait")+"..."}
                                isVisible={wait}
                                setIsVisible={setWait}
                            />
                        </View>
                    ) : (
                        <View>
                            <DrawerItem
                                style={drawerStyle.drawerItem}
                                label={() => {
                                    return (
                                        <View style={drawerStyle.itemContainer}>
                                            <CustomSVG svgIcon={LoginIcon}
                                                width={iconSize}
                                                height={iconSize}
                                            />
                                            <Text style={drawerStyle.itemText}>
                                                {trans("Login")}
                                            </Text>
                                        </View>
                                    );
                                }}
                                onPress={() => {
                                    props.navigation.navigate("login");
                                    props.navigation.closeDrawer();
                                }}
                            />
                        </View>
                    )}
                </DrawerContentScrollView>
            </View>
        </>
    );
};

export default DrawerContainer;
